---
title: Lecture 25：函数的极值与最值
tags:
  - 数学
  - 极值
  - 微积分
categories: 
date: 2024-01-14
---
---
## 1.1 函数的极值
### 1.1.1 基本概念
##### **定义**： #函数的极值
> <font color="#ccc1d9">描述：</font>若 $\exists\delta>0$,使得
> 1） $\forall x\in U(x_0,\delta)$ 恒有 $f(x)\geq f(x_0)$, 则称 $f(x)$ 在 $x_{0}$ 取极小值。
> 2） $\forall x\in U(x_0,\delta)\text{ 恒有 }f(x)\leq f(x_0)\text{,则称 }f(x)\text{ 在 }x_0\text{取极大值}$

##### **定理**： #极值的必要条件
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\text{若 }f(x)\text{ 在 }x_0\text{ 处何导,且在 }x_0\text{ 处取得极值,则}$ $f^{\prime}(x_0)=0$

**意义**
+ 对于可导函数，通过这个定理，缩小了函数**可能的极值点**的范围；
+ 1. 对于可导函数，只需要看驻点；
+ 2. 对于不可导的点，只要看驻点和不存在的点；

**极值与驻点的关系**
+ 驻点：
	+ 导数的等于零的点，称之为**函数的驻点**；
	+ 在 $x_0$ 处取到极值，其导数等于零；
+ 驻点和极值点的关系
	+ ![[Pasted image 20240114161815.png]]
+ 对可导函数而言，极值点就是驻点；

**推论 1**：一般函数可能的极值点
+ 1. 导数等于 0 的点；
+ 2. 导数不存在的点；

##### **定理**： #极值第一充分条件
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\text{设 }f(x)\text{ 在 }U(x_0,\delta)\text{内可导,且 }f^{\prime}(x_0)=0\text{(或}f(x)\text{在 }x_0\text{ 处连续})$
> 1）若 $x<x_0$ 时，$f^{\prime}(x)\geq0;x>x_0$ 时，$f^{\prime}(x)\leq0$, 则 $f$ 在 $x_{0}$ 处取极大值
> 2）若 $x<x_0$ 时，$f^{\prime}(x)\leq0;x>x_0$ 时，$f^{\prime}(x)\geq0$, 则 $f$ 在 $x_{0}$ 处取极小值.
> 3）$\text{若}f^{\prime}(x)\text{ 在 }x_0\text{ 的两侧不变号,则 }f\text{ 在 }x_0\text{ 无极值}$

**意义**
+ 判断一点是不是真的极值点；
+ 使用方法：
	+ 由 `极值的必要条件(定理)` `->` 若干可能的极值点 `->` `极值第一充分条件(定理)` `->` 真正的极值点；

**解释**
+ 几何
	+ 分别为情况一和情况二： ![[Pasted image 20240114162335.png]]
+ 优势
	+ 既可以分析导数等于 0 的点，还可以分析导数不存在的点；

##### **定理**： #极值第二充分条件 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\text{设}\quad f^{\prime}(x_0)=0,f^{\prime\prime}(x_0)\neq0$
> 1）当 $f^{\prime\prime}(x_0)<0$, $f(x)$ 在 $x_{0}$ 处取极大值
> 2）当 $f^{\prime\prime}(x_0)>0,\quad f(x)$在 $x_{0}$ 处取极小值

**解释**
+ 意义：
	+ 通过导数等于 0 的点的**二阶导数**的值来判定一点**是否取到极值**；
+ 局限性：
	+ 无法分析导数不存在的点；

### 1.1.2 例题
**例题**：$\text{求函数 }f(x)=x^3-3x^2-9x+5\text{ 的极值}$
+ 分析
	+ 由形式可知，**函数是可导函数 -> 可导函数的极值点只可能在驻点位置取到**；
	+ 但驻点不一定是极值点；要用充分条件判断 -> 一阶导数为零的点，是否变符号（正负）；
+ 解析
	+ 用第一充分条件
		+ $f(x)=3x^{2}-6x-9=3\left(x_{-2}^{2}x-3\right)=3(x-3)(x+1)=0\Longrightarrow x_{1}=-1,x_{2}=3$
		+ $x=-1$ 处，函数导数从正-> 负，所以为极大值点；
		+ $x=3$ 处，函数导数从负-> 正，所以为极小值点； 
	+ 用第二充分条件
		+  $\begin{aligned}f^{\prime\prime}(x)=6x-6,\quad f^{\prime\prime}(-1)=-12<0,\quad 极大\\f^{\prime\prime}(3)=12>0\quad 极小\end{aligned}$
+ 题型： #函数的极值


## 1.2 最大值与最小值
##### **定义**： #连续函数最大值与最小值
> <font color="#ccc1d9">描述：</font> $\text{求连续函数 }f(x)\text{ 在 }[a,b]\text{ 上的最值}$
> 0）建立目标函数（应用题时）
> 1）求出 $f(x)$ 在 $(a,b)$ 内的驻点、不可导的点以及端点 $x_1,x_2,x_3 ...$ ；
> 2）求出各点的函数值
> 3）将求出来的数值和端点比较，大的为最大值，小的为最小值

**解释**
+ 若连续函数 f (x)在 `(a,b)` 内仅有唯一极值点 `->` 如果极大、就是极大；如果极小、就是极小；

**补充**：最大最小值问题的应用题
+ 第一步：建立目标函数 $y=f(x)$
+ 转换成一般问题

**例题**：$\text{求 }f(x)=2x^3-3x^2\text{ 在 [-1,2] 上最大值和最小值}$
+ 分析
	+ 因为是多项式，因此不存在导数不存在的点，因此只需要求导数等于零的点；
+ 解析
	+ $f^{\prime}(x)=6x^2-6x=6x(x-1)=0\Longrightarrow x_1=0,x_2=1$
	+ 求驻点的值
		+ $f(0)=0,f(1)=-1$
	+ 求端点的值
		+ $f(-1)=-5,f(2)=4$
	+ 所以 x=-1 为最小点，x=2 为最大点
+ 题型： #连续函数最大值与最小值 

## 1.3 相关题型
### 题型： #求函数的极值和最值
#### PART 1：解题方法
**核心**：由 `极值的必要条件(定理)` `->` 若干可能的极值点 `->` `极值第一充分条件(定理)` `->` 真正的极值点；

**可能的极值点**
+ 1. 导数等于 0 的点；
+ 2. 导数不存在的点；

**判断可能的极值点是否真的是极值点**
+ 导数存在时：可以使用极值第一充分条件  `->` 导数极限左右是否变号 `->` 导数从正变负：极大值 + 导数从负变正：极小值；
+ 导数不存在：
	+ 1. 函数连续时：可以使用极值第一充分条件 + 导数连续 `->` 可以推导导数不存在的点是否为极值 `->` 导数从正变负：极大值 + 导数从负变正：极小值；
	+ 2. 不清楚函数是否连续：使用极值第一充分条件 + 判断这一点是否连续（左右极限是否相等） `->` 如果连续 `->` 导数从正变负：极大值 + 导数从负变正：极小值；
+ 或者使用极值第二充分条件 `->` 二阶导数不等于 0；

**补充**：关于函数的导数以及左右导数
+ 如果导数的左右导数当中有一个不存在，则这一点导数不存在；
+ 并且如果已经判断出来左右导数中有一个，则另外一半就不需要讨论了；

**根据函数式子求导数**
+ 1. 分析函数，看其中有没有导数不存在的点 `->` 通常分段函数的分界点、0 点周围都可能是导数不存在的点；
+ 2. 去掉不存在的点后，对函数求导；

**最大最小值的应用题**：先建立目标，在使用求最大最小值的方法求解；
+ 注意：目标函数通常不唯一，可以思考是否有更简单的目标函数；

#### PART 2：典型例题
**例题**：已知 $f(x)$ 在 $x=0$ 的某个邻域内连续，且 $f(0)=0,\lim_{x\to0}\frac{f(x)}{1-\cos x}=2$,则在点 $x=0$ 处 $f(x)$ __
+ 分析
+ 解析
	+ 直接法：
		+ 由于 $\lim_{x\to0}\frac{f(x)}{1-\cos x}=2$，并且 $1-conX$ 在 x 点附近大于 0 `->` 所以在 0 点附近，$f(x)>0$ ；
		+ 因为在 0 点处，$f(0)=0$，而又在 0 点附近，$f(x)>0$ ；
		+ 所以可知：$f(0)=0$ 为 0 点附近的最小点，取得最小值；
	+ 排除法：
		+ 带入具体函数，分析；
		+ 令 $f(x)=x^2$，此时其满足题目所有条件；
		+ 由此可知 $f(x)=x^2$ 在 0 点取得最小值，并且极限存在、可导，且导数等于 0；
+ 题型：#

#### PART 3：知识点复盘


